-- CourseContents.
-- shows up in course mode and takes over... well, everything else.
local contents = Def.ActorFrame{
	Def.Quad{
		InitCommand=cmd(x,80;y,140;zoomto,300,40;MaskSource);
	};

	Def.CourseContentsList {
		MaxSongs = 8; -- this is hardcoded to 8 no matter what I put?
		-- tricky: this defines where the masks are vertically.
		NumItemsToDraw = 4;

		-- tricky: masks are set relative to the CourseContentsList,
		-- while our contents are in another ActorFrame altogether.
		InitCommand=cmd(x,80;y,56;SetMask,0,0;MaskDest);
		BeginCommand=cmd(playcommand,"Refresh");
		OnCommand=cmd(playcommand,"Refresh";SetPauseCountdownSeconds,0.55);
		OffCommand=cmd(stoptweening);

		RefreshCommand=function(self)
			self:SetFromGameState();
			self:SetLoop(false);
			self:SetPauseCountdownSeconds(0.05);
			--self:setsecondsperitem(0.45);
			self:SetSecondsPauseBetweenItems(0);
			self:SetCurrentAndDestinationItem(-3);

			self:playcommand("ScrollUp");
			self:setsecondsperitem(0.25);
		end;

		ScrollDownCommand = function(self)
			self:finishtweening();
			self:setsecondsperitem(1);
			self:SetDestinationItem( (self:GetNumChildren()-1)-1 );
			local fTime = SSC and self:GetSecondsToDestination() or self:getsecondtodestination();
			self:sleep(fTime + 1);
			self:queuecommand("ScrollUp");
		end;

		ScrollUpCommand = function(self)
			self:finishtweening();
			self:setsecondsperitem(0.35);
			self:SetDestinationItem( 1.5 );
			local fTime = SSC and self:GetSecondsToDestination() or self:getsecondtodestination();
			self:sleep(fTime + 1);
			self:queuecommand("ScrollDown");
		end;

		CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Refresh");
		CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Refresh");

		-- tricky: setsize determines the mask's width/height?
		Display = Def.ActorFrame { 
			InitCommand=cmd(setsize,300,40);

			LoadActor( THEME:GetPathB("","_frame 3x3"), "_square blackinset transparent normal", 256, 12)..{
				Name="Frame";
			};

			AutoText("frutiger") .. {
				Name="SongNumber";
				InitCommand=cmd(x,-120;NoStroke;shadowlength,1;zoom,0.8;diffusebottomedge,color("#BBBBBB"));
				SetSongCommand=function(self, params)
					self:settext(string.format("%i", params.Number));
				end;
			};

			AutoText("frutiger") .. {
				Name="Song";
				InitCommand=cmd(x,-104;NoStroke;shadowlength,1;horizalign,left;zoom,0.8);
				SetSongCommand=function(self, params)
					self:maxwidth(256);
					if params.Song then
						self:settext( params.Song:GetDisplayFullTitle() );
					else
						self:settext( "[onos, hidden song!!]" );
					end
				end;
			};

			AutoText("frutiger") .. {
				Name="SongDifficulty";
				InitCommand=cmd(x,128;zoom,0.8;NoStroke;shadowlength,1;horizalign,right;maxwidth,40);
				SetSongCommand=function(self, params)
					if params.PlayerNumber ~= GAMESTATE:GetMasterPlayerNumber() then return end
					self:settext( params.Meter );
					self:diffuse( DifficultyColor(params.Steps:GetDifficulty()) );
				end;
			};
		};
	};
};

return contents;

-- "whenever you see 'tricky' you should read it as 'glenn maynard'"
-- -anonymous zig after seeing this code for the first time back in 2008